#version 330
#extension GL_EXT_gpu_shader4 : enable
//Untitled 0x00000008Mod01.fsh  by harry7557558 
//https://www.shadertoy.com/view/3dcGRf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define AA 2
#define Unit 0.5*length(iResolution.xy)


// Modeling

#define MIN_D 1e-2
#define MAX_D 1e+3
#define RTMinD 1e-2
#define RTMaxD 1e+12

const float h=0.5, h1=0.51, w=1.618, s=10.0, wp=1.0;
const vec2 r = vec2(s,s*w);

float surf(vec3 p, out vec3 grad) {
    float m=length(p.xy), n=m-iTime;
    float r=h*sin(n);
    m=h*cos(n)/m;
    grad.x=p.x*m;
    grad.y=p.y*m;
    grad.z=1.0;
    //return (p.z+r)/sqrt(dot(grad,grad)+1.0);
    return 0.9*(p.z+r)/length(grad);
}
bool surfint(vec3 p, vec3 d, out float t, out vec3 n){
    if (d.z>0.0 && p.z>h1) return false;
    float sd;
    t=10.0*MIN_D;
    if (d.z<0.0&&p.z>h1) t=-(p.z-1.0)/d.z;
    for (int i=0;i<100;i++){
        sd=surf(p+t*d,n);
        if (sd<-MIN_D) return false;
        t+=sd;
        if (t>MAX_D) return false;
        if (t<MIN_D) break;
    }
    return true;
}

bool sphint(vec3 p, vec3 d, out float t, out vec3 n){
    p.z-=h1+1.0;
    if (dot(p, d) >= 0.0) return false;
	vec3 k = cross(p, d); float rd2 = dot(k,k); if (rd2 >= 1.0) return false;
	t = sqrt(dot(p,p) - rd2) - sqrt(1.0 - rd2); if (t < RTMinD) return false;
	n = p + t * d; return true;
}

// a debugging function, it looks nice so I decide to keep it
// example image at iTime=1.90 see https://i.imgur.com/flZjpMR.png
/*bool trackint(vec3 p, vec3 d, out float t, out vec3 n){
    const float s=3.0;
    float t1 = d.x+d.y/w, t2 = p.x+p.y/w, delta=4.0*s;
    float a=2.*t1*t1, b=2.*t1*t2-delta*d.z, c=t2*t2+delta*(h1-p.z);
    delta=sqrt(b*b-2.*a*c); if (delta<0.) return false;
    delta=sqrt(delta)/a; b=-b/a;
    t1=b+delta,t2=b-delta;
    if (t1<RTMinD) t1=RTMaxD; if (t2<RTMinD) t2=RTMaxD;
    t=min(t1,t2); if (t>=RTMaxD) return false;
    vec3 q=p+t*d;
    t1=0.5/s*(q.x+q.y/w), n=vec3(t1,t1/w,-1.);
    t1=length(n.xy/vec2(1.,w)), t2=length(n.xy/vec2(1./w*w));
  	delta=t1*(t1-1.0)/t2/length(n.xy);
    if (abs(delta)>0.1) return false;
    n=normalize(n);
    return true;
}*/
bool trackint(vec3 p, vec3 d, out float t, out vec3 n){
    float t1 = d.x+d.y/w, t2 = p.x+p.y/w, delta=4.0*s;
    float a=t1*t1, b=2.*t1*t2-delta*d.z, c=t2*t2+delta*(h1-p.z);
    delta=b*b-4.*a*c; if (delta<0.) return false;
    a*=2.0,delta=sqrt(delta)/a; b=-b/a;
    t1=b+delta,t2=b-delta;
    vec3 q;
#define Test(t0) q=p+t0*d; \
  a=0.5/s*(q.x+q.y/w), n=vec3(a,a/w,-1.); \
  b=length(q.xy/r), c=length(q.xy/(r*r)), a=b*(b-1.0)/c*length(n); \
  if (abs(a)<wp) t=t0;
    t=RTMaxD;
    if (t1>RTMinD) {Test(t1)}
    if (t2>RTMinD&&t2<t) {Test(t2)}
    if (t==RTMaxD) return false;
    q=p+t*d;
    a=0.5/s*(q.x+q.y/w), n=normalize(vec3(a,a/w,-1.));
    return true;
}


// Rendering

#define sunpos normalize(vec3(1.0,-1.0,0.5))
#define fogcol vec3(1.0,0.7,0.4)
#define skycol vec3(0.6,0.8,1.0)
#define suncol vec3(0.9,0.8,0.5)
#define fogD 0.008

vec3 skycolor(vec3 d){
    vec3 col;
    float sky=(0.2-0.8)*max(d.z,0.0)+0.8;
    col=sky*skycol;
    float horizon=pow(1.0-d.z*d.z,100.0);
    col=mix(col,vec3(1.0),horizon);
    float sun=max(dot(d,sunpos),0.0);
    col+=pow(sun,150.0)*suncol;
    return col;
}
float fog(vec3 d){
    if (d.z<=0.0) return 1.0;
    return pow(1.0-d.z*d.z,200.0);
}

vec3 calcCol(vec3 p, vec3 d){
    float a=0.0;
    for (int i=0;i<16;i++){
    	float t=0.0, mt=MAX_D; vec3 n, mn; bool r=false;
        if (sphint(p,d,t,n)) r=true, mn=n, mt=t; 	// vec3(135,250,206)/256.0;
        if (trackint(p,d,t,n) && t<mt) r=true, mn=n, mt=t; 	// vec3(250,206,135)/256.0
        if (surfint(p,d,t,n) && t<mt) mt=t, mn=normalize(n), r=true; 	// vec3(135,206,250)/256.0
        if (r) {
            p+=mt*d;
            d-=2.0*dot(mn,d)*mn;
        	a+=mt;
        }
        else { // calculate sky color as final output
            a=exp(-fogD*a);
            vec3 sky=skycolor(d);
            sky=mix(sky,fogcol,fog(d));
            return mix(fogcol,sky,a);
        }
    }
    return fogcol;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float h = cos(0.4*iTime)+2.0;
    float r = 0.5*(cos(iTime)+1.0) + 10.0;
    vec3 pos = 5.0*cos(0.5*iTime)*vec3(r*cos(iTime), r*sin(iTime), h);
    vec3 dir = vec3(0.0,0.0,1.0+h1)-pos;

    float rz=atan(dir.x,-dir.y), rx=atan(length(dir.xy),dir.z);
    mat3 M=mat3(cos(rz),sin(rz),0,-sin(rz),cos(rz),0,0,0,1)*mat3(1,0,0,0,cos(rx),sin(rx),0,-sin(rx),cos(rx));

    vec3 col = vec3(0.0,0.0,0.0), ecol;
    for (int i=0;i<AA;i++) for (int j=0;j<AA;j++) {
        vec3 d = M*vec3(0.5*iResolution.x-(gl_FragCoord.x+float(i)/float(AA)),-0.5*iResolution.y+(gl_FragCoord.y+float(j)/float(AA)),Unit);
        ecol = calcCol(pos,normalize(d));
    	if (dot(ecol,vec3(0.3,0.59,0.11))<0.1) ecol=fogcol;
        col+=ecol;
    }

    gl_FragColor = vec4(col/float(AA*AA),1.0);
}
